<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BonusLedger extends Model
{
    use HasFactory;

    protected $table = 'bonus_ledgers'; // nama tabel di database
    protected $fillable = [
        'user_id',
        'bonus_id',
        'bonus_code',
        'amount',
    ];

    // Relasi ke user
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    // Relasi ke bonus
    public function bonus()
    {
        return $this->belongsTo(Bonus::class);
    }
}