@extends('admin.layouts.app')

@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5>@lang('Manage Bonus')</h5>
        <a href="{{ route('admin.bonus.create') }}" class="btn btn-primary">@lang('Add Bonus')</a>
    </div>
    <div class="card-body">
        <table class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>@lang('ID')</th>
                    <th>@lang('Bonus Name')</th>
                    <th>@lang('Code')</th>
                    <th>@lang('Amount')</th>
                    <th>@lang('Status')</th>
                    <th>@lang('Actions')</th>
                </tr>
            </thead>
            <tbody>
                @foreach($datas as $bonus)
                <tr>
                    <td>{{ $bonus->id }}</td>
                    <td>{{ $bonus->bonus_name }}</td>
                    <td>{{ $bonus->code }}</td>
                    <td>{{ $bonus->amount }}</td>
                    <td>{{ $bonus->status }}</td>
                    <td class="d-flex gap-1">
                        <a href="{{ route('admin.bonus.status', $bonus->id) }}" class="btn btn-sm btn-success">@lang('Activate')</a>
                        <a href="{{ route('admin.bonus.create', $bonus->id) }}" class="btn btn-sm btn-warning">@lang('Edit')</a>
                        <form action="{{ route('admin.bonus.delete', $bonus->id) }}" method="POST" style="display:inline-block;">
                            @csrf
                            @method('DELETE')
                            <button class="btn btn-sm btn-danger" type="submit" onclick="return confirm('@lang('Are you sure?')')">@lang('Delete')</button>
                        </form>
                        <a href="{{ route('admin.bonus.view', $bonus->id) }}" class="btn btn-sm btn-info">@lang('View')</a>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endsection