@extends($activeTemplate.'layouts.master')
@section('content')

<body class="tiktok-theme">

<div class="dashboard-header">
    <span class="topTit">market</span>
</div>

<div class="home-device">

    <div class="inline-change">
        <ul>
            <li class="cur"><a href="">Paket Affiliate</a></li>
        </ul>
    </div>

    <div class="home-product">
        <div class="home-product-list">
            @foreach ($plans as $plan)
            <form action="{{ route('user.invest.submit') }}" method="post">
                @csrf
                <input type="hidden" name="plan_id" value="{{ __($plan->id) }}">
                <input type="hidden" name="wallet_type" value="deposit_wallet">
                <input type="hidden" name="amount" value="{{ getAmount($plan->fixed_amount,0) }}">
                
                <div class="plan-box">
                    <div class="plan-header">
                        <img src="{{asset ('core/img/tiktok.jpg')}}" alt=""/>
                        <div class="plan-title">
                            <h4>{{ __($plan->name) }}</h4>
                            <p class="price">{{ __($general->cur_text) }} {{ showAmount($plan->fixed_amount) }}</p>
                        </div>
                    </div>
                    
                    <div class="plan-body">
                        <div class="row">
                            <span>Harga</span>
                            <span>{{ __($general->cur_text) }} {{ showAmount($plan->fixed_amount) }}</span>
                        </div>
                        <div class="row">
                            <span>Masa Aktif</span>
                            <span>{{ __($plan->repeat_time) }} {{ __($plan->timeSetting->name) }}</span>
                        </div>
                        <div class="row">
                            <span>Komisi Harian</span>
                            <span>{{ showAmount($plan->interest) }}{{ $plan->interest_type == 1 ? '%' : '' }}</span>
                        </div>
                        <div class="row">
                            <span>Total Komisi</span>
<span>
    @if ($plan->lifetime == 0)
        @if ($plan->capital_back == 1)
            @lang('capital') +
        @endif
        @if ($plan->interest_type == 1)
            {{ number_format($plan->interest * $plan->repeat_time, 2, '.', ',') }}%
        @else
            {{ $general->cur_sym }} {{ number_format($plan->interest * $plan->repeat_time, 2, '.', ',') }}
        @endif
    @else
        @lang('Unlimited')
    @endif
</span>
                        </div>
                    </div>

                    <button class="plan-btn">
                        Beli Sekarang - {{ __($general->cur_text) }} {{ showAmount($plan->fixed_amount) }}
                    </button>
                </div>
            </form>
            @endforeach
        </div>
    </div>

</div>

@endsection

@push('style')
<style>
body.tiktok-theme {
    background:#000 !important;
    color:#000 !important;
    font-family:'Maven Pro', sans-serif;
    padding-bottom:100px;
}

.dashboard-header {
  background: #222 !important;
  color: #fff !important;
  text-align: center;
  font-size: 14px;
  font-weight: 600; 
  padding:14px 0px;
  border-bottom: 2px solid gold;
  border-radius: 0 0 30px 30px;
  box-shadow: 0 3px 10px rgba(255, 215, 0, 0.4);
  margin-bottom: 18px;
}

/* Tab menu */
.inline-change ul {
    display:flex;
    justify-content:center;
    gap:15px;
    padding:10px 0;
    list-style:none;
    margin:0;
}
.inline-change ul li a {
    color:#aaa !important;
    font-size:13px;
    text-decoration:none !important;
    padding:100px 100px!important;
    border-radius:8px;
    transition:all .3s ease;
}
.inline-change ul li a:hover {
    color:#fff;
    background:#222;
}
.inline-change ul li.cur a {
    color:#000 !important;
    font-weight:700 !important;
    background:gold!important;
    border-radius:20px !important;
    padding:6px 14px !important;
    box-shadow:0 3px 10px rgba(255,0,80,0.6);
    transform:scale(1.05);
}

/* Kotak produk */
.plan-box {
    background:#1c1c1c;
    border-radius:14px;
    overflow:hidden;
    border:1px solid #333;
    margin-bottom:16px;
    box-shadow:0 4px 12px rgba(0,0,0,0.4);
}
.plan-header {
    display:flex;
    align-items:center;
    padding:12px;
    gap:12px;
}
.plan-header img {
    width:70px;
    height:70px;
    border-radius:12px;
    object-fit:cover;
}
.plan-title h4 {
    font-size:15px;
    font-weight:600;
    color:#fff; /* judul emas */
    margin:0 0 4px;
}
.plan-title .price {
    font-size:16px;
    font-weight:700;
    color:#ffd700; /* harga emas */
    text-shadow:0 0 6px rgba(255,215,0,0.6);
    margin:0;
}

/* isi detail */
.plan-body {
    background:#2a2a2a;
    margin:0 12px 12px;
    padding:12px;
    border-radius:10px;
}
.plan-body .row {
    display:flex;
    justify-content:space-between;
    font-size:13px;
    padding:6px 0;
    border-bottom:1px solid #444;
}
.plan-body .row:last-child {
    border-bottom:none;
}
.plan-body .row span:first-child {
    color:#bbb;
}
.plan-body .row span:last-child {
    color:#ffd700; /* nilai emas */
    font-weight:700;
    text-shadow:0 0 6px rgba(255,215,0,0.5);
}

/* tombol bawah */
.plan-btn {
    display:block;
    width:100%;
    padding:12px 0;
    font-size:14px;
    font-weight:700;
    text-align:center;
    background: linear-gradient(90deg, #ffd700 0%, #e6c200 100%);
    color:#000;
    border:none;
    border-radius:0 0 14px 14px;
    cursor:pointer;
    transition:all .2s ease;
    box-shadow:0 4px 10px rgba(255,215,0,0.4);
}
.plan-btn:hover {
    background:linear-gradient(90deg, #fff5b0, #ffd700);
    box-shadow:0 6px 14px rgba(255,215,0,0.6);
} 
.home-device {
  margin-top: -70px !important; /* 🔥 narik ke atas */
}
</style>
@endpush