@extends($activeTemplate . 'layouts.master')
@section('content')

<body class="tiktok-theme">
    <div class="dashboard-header">
        <a href="" class="topLeft"></a>
        <div class="topTit">Riwayat</div>
    </div>

    <div class="dashboard-container">
        <!-- Tabs -->
        <div class="tabs">
            <ul>
                <li><a href="{{ route('user.transactions') }}">Semua</a></li>
                <li class="active"><a href="{{ route('user.deposit.history') }}">Isi Saldo</a></li>
                <li><a href="{{ route('user.withdraw.history') }}">Penarikan</a></li>
            </ul>
        </div>

        <!-- Deposit History -->
        <div class="history-list">
            @forelse($deposits as $deposit)
                <div class="history-card">
                    <div class="card-left">
                        <h3 class="trx">ID: {{ $deposit->trx }}</h3>
                        <h2 class="amount gold-text">{{ $general->cur_text }} {{ showAmount($deposit->amount) }}</h2>
                        <p class="time">{{ showDateTime($deposit->created_at, 'd M Y @ H:i') }}</p>
                    </div>
                    <div class="card-right">
                        @php echo $deposit->statusBadge @endphp
                    </div>
                </div>
            @empty
                <div class="no-data">Tidak ada data lagi</div>
            @endforelse
        </div>
    </div>
</body>

@endsection

<style>
/* TikTok dark style */
body.tiktok-theme {
    background: #000;
    color: #fff;
    font-family: Arial, sans-serif;
    margin: 0;
    padding: 0;
}

.dashboard-header {
    background: #111;
    padding: 15px;
    text-align: center;
    font-size: 18px;
    font-weight: bold;
    position: sticky;
    top: 0;
    z-index: 100;
    border-bottom: 1px solid #222;
}

.topTit {
    color: #fff;
}

.tabs {
    margin: 10px;
}
.tabs ul {
    display: flex;
    justify-content: space-around;
    background: #111;
    border-radius: 12px;
    overflow: hidden;
}
.tabs ul li {
    flex: 1;
    text-align: center;
}
.tabs ul li a {
    display: block;
    padding: 10px 0;
    color: #aaa;
    font-size: 14px;
    text-decoration: none;
}
.tabs ul li.active a {
    color: #fff;
    font-weight: bold;
    border-bottom: 2px solid gold;
}

.history-list {
    margin: 15px;
}

.history-card {
    background: #111;
    border-radius: 10px;
    padding: 15px;
    margin-bottom: 12px; 
    width: 98%;
    margin-left: -13px;          /* geser ke kiri */
    display: flex;
    justify-content: space-between;
    align-items: center; 
    border: 2px solid gold;  /* border gold polos */
}
.history-card .trx {
    font-size: 13px;
    color: #888;
    margin: 0;
}
.history-card .amount {
    font-size: 18px;
    font-weight: bold;
    margin: 5px 0;
}
.history-card .time {
    font-size: 12px;
    color: #666;
}
.history-card .card-right {
    font-size: 14px;
    font-weight: bold;
}

.no-data {
    text-align: center;
    padding: 20px;
    color: #666;
}

/* Teks gold untuk nominal */
.gold-text {
    background: gold;
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    font-weight: 700;
}
</style>