@extends($activeTemplate . 'layouts.master')
@section('content')

<body class="tiktok-theme">
    <div class="dashboard-header">
        <a class="topLeft"></a>
        <div class="topTit">Gaji Harian</div>
    </div>

    <div class="dashboard-container">
        <div class="salary-list">
            @forelse($invests as $invest)
                @php
                    if ($invest->last_time) {
                        $start = $invest->last_time;
                    } else {
                        $start = $invest->created_at;
                    }
                @endphp

                @if ($invest->status == 1)
                    <div class="salary-card">
                        <div class="salary-card-title">Gaji Harian</div>
                        <div class="salary-card-body">
                            <ul>
                                <li>
                                    <span>Paket</span>
                                    <label>{{ __($invest->plan->name) }}</label>
                                </li>
                                <li>
                                    <span>{{ __($general->cur_text) }} {{ showAmount($invest->paid) }}</span>
                                    <label>Total Komisi</label>
                                </li>
                                <li>
                                    <span>
                                        {{ showAmount($invest->plan->interest) }}{{ $invest->plan->interest_type == 1 ? '%' : ' ' . __($general->cur_text) }}
                                    </span>
                                    <label>Komisi Harian</label>
                                </li>
                            </ul>
                            <div class="salary-card-footer">
                                <button type="button" class="disabled">Sudah Diterima</button>
                            </div>
                        </div>
                    </div>
                @endif
            @empty
                <div class="no-data">Tidak ada data</div>
            @endforelse
        </div>
    </div>

    <!-- Popup Bonus -->
    <div class="z-mask mask-content" style="display: none">
        <div class="mask-bonus">
            <img src="/static/home/images/icon_6.png">
            <div class="mask-bonus-tit"></div>
            <div class="mask-bonus-txt">
                <p>Bonus Berhasil Didapatkan</p>
                <p>Mohon tunggu persetujuan!</p>
            </div>
            <div class="mask-bonus-btn">
                <button type="button">Konfirmasi</button>
            </div>
        </div>
    </div>
</body>

@endsection

<style>
/* TikTok dark style */
body.tiktok-theme {
    background: #000;
    color: #fff;
    font-family: Arial, sans-serif;
    margin: 0;
    padding: 0;
}

.dashboard-header {
    background: #111;
    padding: 15px;
    text-align: center;
    font-size: 18px;
    font-weight: bold;
    position: sticky;
    top: 0;
    z-index: 100;
    border-bottom: 1px solid #222;
}

.topTit {
    color: #fff;
}
.salary-card {  
    background: #111;  
    border-radius: 12px;  
    padding: 15px;  
    margin-bottom: 12px;  
}  
.salary-card-title {
    font-size: 16px;
    font-weight: bold;
    margin-bottom: 10px;
}
.salary-card-body ul {
    list-style: none;
    padding: 0;
    margin: 0;
}
.salary-card-body li {
    display: flex;
    justify-content: space-between;
    padding: 6px 0;
    border-bottom: 1px solid #222;
}
.salary-card-body li span {
    color: #fff;
    font-size: 14px;
}
.salary-card-body li label {
    color: #888;
    font-size: 13px;
}
.salary-card-footer {
    margin-top: 10px;
    text-align: right;
}
.salary-card-footer button {
    background: #333;
    color: #aaa;
    border: none;
    padding: 8px 16px;
    border-radius: 20px;
    font-size: 13px;
}
.salary-card-footer button.disabled {
    opacity: 0.6;
    cursor: not-allowed;
}

.no-data {
    text-align: center;
    padding: 20px;
    color: #666;
}

.mask-content {
    position: fixed;
    top: 0; left: 0; right: 0; bottom: 0;
    background: rgba(0,0,0,0.8);
    display: flex;
    justify-content: center;
    align-items: center;
}
.mask-bonus {
    background: #111;
    border-radius: 12px;
    padding: 20px;
    text-align: center;
    color: #fff;
}
.mask-bonus img {
    width: 60px;
    margin-bottom: 15px;
}
.mask-bonus-btn button {
    margin-top: 15px;
    background: #ff2d55;
    color: #fff;
    border: none;
    padding: 10px 20px;
    border-radius: 20px;
    cursor: pointer;
}
</style>