@extends($activeTemplate.'layouts.master')
@section('content')

<body class="tiktok-theme">
    <div class="dashboard-header">
        <a href="" class="topLeft"></a>
        <div class="topTit">Ubah Kata Sandi</div>
    </div>

    <div class="dashboard-container">
        <form action="" method="post">
            @csrf
            <div class="card-container">
                <div class="card-info">
                    <input type="password" name="current_password" placeholder="Masukkan kata sandi lama" required />
                </div>
                <div class="card-info">
                    <input type="password" name="password" placeholder="Masukkan kata sandi baru" required />
                </div>
                <div class="card-info">
                    <input type="password" name="password_confirmation" placeholder="Konfirmasi kata sandi baru" required />
                </div>
                <button class="card-btn">Konfirmasi</button>
            </div>
        </form>
    </div>
</body>

@endsection

<style>
/* TikTok dark style */
body.tiktok-theme {
    background: #000;
    color: #fff;
    font-family: Arial, sans-serif;
    margin: 0;
    padding: 0;
}

.dashboard-header {
    background: #111;
    padding: 15px;
    text-align: center;
    font-size: 18px;
    font-weight: bold;
    position: sticky;
    top: 0;
    z-index: 100;
    border-bottom: 1px solid #222;
}
.topTit {
    color: #fff;
}

.dashboard-container {
    padding: 20px;
}

.card-container {
    background: #222!important;
    border-radius: 12px;
    padding: 20px;
    max-width: 400px;
    margin: 0 auto;
}

.card-info {
    margin-bottom: 15px;
}
.card-info input {
    width: 100%;
    padding: 12px;
    border-radius: 8px;
    border: none;
    background: #111;
    color: #000;
    font-size: 14px;
}
.card-info input::placeholder {
    color: #777;
}

.card-btn {
  width: 100%;
  padding: 12px;
  background: gold!important;
  border: none;
  border-radius: 8px;
  color: #fff!important;
  font-size: 15px;
  font-weight: bold;
  cursor: pointer;
  transition: 0.3s;

  display: flex;              /* aktifin flexbox */
  justify-content: center;    /* rata tengah horizontal */
  align-items: center;        /* rata tengah vertical */
}
.card-btn:hover {
  background: #ff3d65;
}
</style>