@extends($activeTemplate . 'layouts.master')

@section('content')
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style> 
 body{ 
     background: #111; 
} 
.dashboard-header {  
  background: #000 !important;  
  color: #fff !important;  
  text-align: center;  
  font-size: 14px;  
  font-weight: 600;  
  padding: 14px 0;  
  border-bottom: 2px solid #FFD700;  /* garis gold di bawah */  
  border-radius: 0 0 30px 30px;  /* lengkung bawah kiri-kanan */  
  margin: 0;  
  position: fixed;  
  top: 0;  
  left: 0;  
  width: 100%;  
  z-index: 10;  
}

/* biar konten gak ketiban header */
.team-wrap {
  padding: 80px 15px 20px 15px;
}
/* gaya metal-card */
.team-card {
  background: linear-gradient(145deg, #1a1a1a, #0e0e0e);
  border: 1px solid rgba(255, 215, 0, 0.4);
  border-radius: 14px;
  text-align: center;
  color: #FFD700;
  padding: 12px 8px;
  box-shadow: inset 0 0 10px rgba(255, 215, 0, 0.2),
              0 3px 10px rgba(255, 215, 0, 0.25);
  transition: all 0.35s ease;
  position: relative;
  overflow: hidden;
}

/* efek pantulan logam */
.team-card::before {
  content: "";
  position: absolute;
  top: -50%;
  left: -50%;
  width: 200%;
  height: 200%;
  background: linear-gradient(120deg, rgba(255,255,255,0.08) 0%, rgba(255,255,255,0) 60%);
  transform: rotate(25deg);
  opacity: 0;
  transition: opacity 0.4s ease;
}

.team-card:hover::before {
  opacity: 1;
}

.team-card:hover {
  transform: translateY(-3px);
  border-color: #FFD700;
  box-shadow: 0 0 20px rgba(255, 215, 0, 0.45);
}

/* biar kecil dan mewah */
.col-6 {
  flex: 0 0 48%;
  max-width: 48%;
}

.row.g-3 {
  justify-content: center;
  row-gap: 14px;
  column-gap: 10px;
}

/* teks di dalam kartu */
.team-title {
  font-size: 0.75rem;
  font-weight: 600;
  color: rgba(255, 215, 0, 0.85);
  text-transform: uppercase;
  letter-spacing: 0.4px;
  margin-bottom: 5px;
}

.team-value {
  font-size: 1.2rem;
  font-weight: 700;
  color: #fff;
  text-shadow: 0 0 6px rgba(255, 215, 0, 0.3);
}
</style>

<div class="team-wrap">
    <div class="container">
        <div class="row g-3">
<div class="dashboard-header">  
    <span class="topTit">Rincian tim</span>  
</div>   
            <div class="col-6">
                <div class="team-card">
                    <div class="team-title">UKURAN TIM</div>
                    <div class="team-value">{{ refTotalCount($user->id) }}</div>
                </div>
            </div>

            <div class="col-6">
                <div class="team-card">
                    <div class="team-title">TOTAL DEPOSIT TIM</div>
                    <div class="team-value">{{ $general->cur_sym }}{{ showAmount(refTotalDeposit($user->id)) }}</div>
                </div>
            </div>

            <div class="col-6">
                <div class="team-card">
                    <div class="team-title">TOTAL PENARIKAN TIM</div>
                    <div class="team-value">{{ $general->cur_sym }}{{ showAmount(refTotalWithdraw($user->id)) }}</div>
                </div>
            </div>

            <div class="col-6">
                <div class="team-card">
                    <div class="team-title">TIM BARU HARI INI</div>
                    <div class="team-value">{{ refTodayCount($user->id) }}</div>
                </div>
            </div>

            <div class="col-6">
                <div class="team-card">
                    <div class="team-title">DEPOSIT PERTAMA HARI INI</div>
                    <div class="team-value">{{ $general->cur_sym }}{{ showAmount(refTodayDeposit($user->id)) }}</div>
                </div>
            </div>

            <div class="col-6">
                <div class="team-card">
                    <div class="team-title">PENARIKAN PERTAMA HARI INI</div>
                    <div class="team-value">{{ $general->cur_sym }}{{ showAmount(refTodayWithdraw($user->id)) }}</div>
                </div>
            </div>

        </div>
    </div>
</div>
@endsection