@extends($activeTemplate . 'layouts.master')
@section('content')
<body class="huiBg tiktok-theme">

<div class="tiktok-header">
    <a class="back-btn">
        <i class="las la-arrow-left"></i>
    </a>
    <div class="title">
        Peringkat Investasi
    </div>
</div>

<div class="ranking-wrapper container">
    @php $nextRanking = $userRankings->where('id', '>', $user->user_ranking_id)->first(); @endphp
    @if ($nextRanking)
        <div class="ranking-card">
            <div class="ranking-card-body">
                <div class="ranking-progress">
                    <img src="{{ getImage(getFilePath('userRanking') . '/' . $nextRanking->icon, getFileSize('userRanking')) }}" alt="icon">
                    <div class="ranking-info">
                        <p class="label">@lang('Investasi Saya')</p>
                        <h4 class="gold-text">
                            {{ $general->cur_sym }}{{ showAmount($user->total_invests) }} / 
                            {{ $general->cur_sym }}{{ showAmount($nextRanking->minimum_invest) }}
                        </h4>
                        @if ($nextRanking->minimum_invest - $user->total_invests > 0)
                            <span class="to-unlock gold-text">
                                {{ $general->cur_sym }}{{ showAmount($nextRanking->minimum_invest - $user->total_invests) }} @lang('To unlock')
                            </span>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    @endif

    <div class="ranking-list row">
        @foreach ($userRankings as $userRanking)
            <div class="col-6 col-md-4">
                <div class="badge-card {{ $user->user_ranking_id >= $userRanking->id ? 'active' : '' }}">
                    <div class="badge-thumb">
                        <img src="{{ getImage(getFilePath('userRanking') . '/' . $userRanking->icon, getFileSize('userRanking')) }}" alt="">
                    </div>
                    <h5>{{ __($userRanking->name) }}</h5>
                    <p class="bonus gold-text">@lang('Bonus'): {{ $general->cur_sym }}{{ showAmount($userRanking->bonus) }}</p>
                </div>
            </div>
        @endforeach
    </div>
</div>

@endsection

@push('style')
<style>
/* TikTok style theme */
body.tiktok-theme {
    background: #000;
    color: #fff;
    font-family: 'Maven Pro', sans-serif;
}
.tiktok-header {
    display:flex;
    align-items:center;
    padding:15px;
    border-bottom:1px solid rgba(255,255,255,0.1);
}
.tiktok-header .title {
    flex:1;
    text-align:center;
    font-weight:600;
    font-size:18px;
}
.back-btn {
    color:#fff;
    font-size:20px;
}
.ranking-wrapper {
    padding:20px 10px;
}
.ranking-card {
    background:#111;
    border-radius:16px;
    padding:15px;
    margin-bottom:20px;
}
.ranking-progress {
    display:flex;
    align-items:center;
    gap:15px;
}
.ranking-progress img {
    width:50px;
    height:50px;
}
.ranking-info h4 {
    font-weight:600;
    margin:0;
}
.to-unlock {
    font-size:13px;
}
.ranking-list {
    margin-top:10px;
}
.badge-card {
    background:#111;
    border-radius:16px;
    text-align:center;
    padding:15px;
    margin-bottom:15px;
    transition:all .3s;
}
.badge-card.active {
    border:2px solid #ff0050; /* TikTok pink */
}
.badge-card img {
    width:60px;
    height:60px;
    margin-bottom:10px;
}
.badge-card h5 {
    font-size:15px;
    font-weight:600;
    margin:0;
}
.badge-card .bonus {
    font-size:13px;
}
/* Warna emas untuk nominal uang */
.gold-text {
    background: linear-gradient(90deg, #FFD700, #FFA500);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    font-weight: 700;
}
</style>
@endpush