@extends($activeTemplate . 'layouts.master')
@section('content')

<style>
body.tiktok-theme {
    margin:0;
    padding:0;
    font-family:'Arial', sans-serif;
    background-color:#000;
    color:#fff;
}

/* TOP BAR */
.top {
    height:60px;
    display:flex;
    align-items:center;
    justify-content:center;
    font-weight:bold;
    font-size:20px;
    background-color:#111;
    position:sticky;
    top:0;
    z-index:10;
    border-bottom:1px solid #222;
}

/* CONTAINER */
.feed-container {
    display:flex;
    flex-direction:column;
    gap:15px;
    padding:10px;
    padding-bottom:120px;
}

/* CARD */
.card {
    background-color:#1a1a1a;
    border-radius:12px;
    padding:15px;
    box-shadow:0 4px 12px rgba(0,0,0,0.5);
    transition:transform 0.2s;
}

.card:hover {
    transform:scale(1.02);
}

/* SALDO */
.balance-card h3 {
    font-size:20px;
    margin:5px 0;
}

.balance-card p {
    color:#aaa;
    margin:0;
}

/* INPUT JUMLAH */
.input-amount input {
    width:100%;
    padding:12px 15px;
    border-radius:12px;
    border:none;
    background-color:#111;
    color:#fff;
    font-size:16px;
    box-sizing:border-box;
}

/* METODE */
.deposit-method select {
    width:100%;
    padding:12px 15px;
    border-radius:12px;
    border:none;
    background-color:#111;
    color:#fff;
    font-size:14px;
    box-sizing:border-box;
    margin-top:10px;
}

.deposit-method p {
    margin:5px 0 0 0;
    font-size:12px;
    color:#aaa;
}

/* TOMBOL */
.withdraw-btn {
    width:100%;
    padding:15px;
    margin-top:15px;
    border:none;
    border-radius:15px;
    background:gold;
    color:#000;
    font-weight:bold;
    font-size:16px;
    cursor:pointer;
    display:flex;
    align-items:center;
    justify-content:center;
}

.withdraw-btn:hover {
    opacity:0.9;
}

/* ATURAN */
.withdraw-rule {
    margin-top:10px;
    font-size:12px;
    color:#aaa;
}

.withdraw-rule .rule-title {
    font-weight:bold;
    margin-bottom:5px;
}

/* RESPONSIVE */
@media (max-width:480px){
    .input-amount input,
    .deposit-method select {
        font-size:14px;
        padding:10px 12px;
    }
}
</style>

<body class="tiktok-theme">
<div class="top">Tarik Saldo</div>

<div class="feed-container">
<form action="{{route('user.withdraw.money')}}" method="post" id="withdrawForm">
@csrf

<!-- SALDO -->
<div class="card balance-card">
    <p>Saldo Dompet</p>
    <h3>{{ showAmount(auth()->user()->interest_wallet) }} {{ __($general->cur_text) }}</h3>
</div>

<!-- INPUT JUMLAH -->
<div class="card input-amount">
    <p>Jumlah Penarikan</p>
    <input type="number" name="amount" value="0" placeholder="Masukkan jumlah penarikan" required>
</div>

<!-- METODE -->
<div class="card deposit-method">
    <p>Metode Penarikan</p>
    <select name="method_code" required>
        <option value="">Pilih Salah Satu</option>
        @foreach($withdrawMethod as $data)
            <option value="{{ $data->id }}" data-resource='@json($data)'>
                {{ __($data->name) }}
            </option>
        @endforeach
    </select>
    <p>Minimal Penarikan <span><span class="min fw-bold">0</span> {{ __($general->cur_text) }} - <span class="max fw-bold">0</span> {{ __($general->cur_text) }}</span></p>
</div>

<!-- TOMBOL -->
<button type="submit" class="withdraw-btn">Tarik Saldo</button>

<!-- ATURAN -->
<div class="card withdraw-rule">
    <div class="rule-title">Aturan Penarikan</div>
    <div class="rule-text">
        <p>1. Masukkan jumlah penarikan sesuai saldo tersedia</p>
        <p>2. Pilih metode penarikan yang tersedia</p>
        <p>3. Klik tombol <b>Tarik Saldo</b> untuk melanjutkan</p>
        <p>4. Anda akan diarahkan ke halaman pengisian data rekening atau e-wallet</p>
        <p>5. Pastikan nama dan nomor tujuan benar sebelum konfirmasi</p>
        <p>6. Jika ada kendala, hubungi layanan pelanggan</p>
    </div>
</div>

</form>
</div>

<script>
(function($){
    "use strict";

    // format angka ke Rupiah style (10.000, 2.000.000, dst)
    function formatID(num){
        return new Intl.NumberFormat('id-ID').format(num);
    }

    $('select[name=method_code]').change(function(){
        let resource = $('select[name=method_code] option:selected').data('resource');
        if(resource && resource.min_limit && resource.max_limit){
            $('.min').text(formatID(resource.min_limit));
            $('.max').text(formatID(resource.max_limit));
        } else {
            $('.min').text("0");
            $('.max').text("0");
        }
    });

    $('#withdrawForm').submit(function(e){
        let amount = $('input[name=amount]').val();
        let method = $('select[name=method_code]').val();
        if(!amount || !method){
            e.preventDefault();
            alert("Mohon pilih metode dan isi jumlah penarikan!");
        }
    });
})(jQuery);
</script>

@endsection