<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\User\WithdrawController;
use App\Http\Controllers\User\SpinController;
use App\Http\Controllers\User\UserController; 
use App\Http\Controllers\Admin\BonusController;
Route::get('/withdraw-proofs', [WithdrawController::class, 'proofsPage'])->name('user.withdraw.proofs');
Route::post('/withdraw-proofs/upload', [WithdrawController::class, 'uploadProof'])->name('user.withdraw.proofs.upload');
Route::get('/clear', function () {
    \Illuminate\Support\Facades\Artisan::call('optimize:clear');
}); 
//bonus
        Route::get('bonus', [BonusController::class, 'index'])->name('admin.bonus.index');
        Route::get('bonus/status/{id}', [BonusController::class, 'status'])->name('admin.bonus.status');
        Route::get('bonus/create/{id?}', [BonusController::class, 'create'])->name('admin.bonus.create');
        Route::post('bonus/insert-update', [BonusController::class, 'insert_or_update'])->name('admin.bonus.insert');
        Route::delete('bonus/delete/{id}', [BonusController::class, 'delete'])->name('admin.bonus.delete');
        Route::get('bonus/uses', [BonusController::class, 'bonuslist'])->name('admin.bonuslist.index');//Customer bonus uses
        Route::get('bonus/view/{id}', [BonusController::class, 'view'])->name('admin.bonus.view');
//Bonus
        Route::get('message', [UserController::class, 'message'])->name('message');
        Route::post('submit-bonus-confirm', [SpinController::class, 'submitBonusCodeconfirm'])->name('user.submit-bonus-confirm');
        Route::get('spin', [SpinController::class, 'spin'])->name('spin');
        Route::get('submit-bonus-check/{code}', [SpinController::class, 'submitbonuscheck']);
        Route::get('submit-bonus-amount', [SpinController::class, 'submitbonusamount']);

Route::get('cron', 'CronController@cron')->name('cron');

// User Support Ticket
Route::controller('TicketController')->prefix('ticket')->name('ticket.')->group(function () {
    Route::get('/', 'supportTicket')->name('index');
    Route::get('new', 'openSupportTicket')->name('open');
    Route::post('create', 'storeSupportTicket')->name('store');
    Route::get('view/{ticket}', 'viewTicket')->name('view');
    Route::post('reply/{ticket}', 'replyTicket')->name('reply');
    Route::post('close/{ticket}', 'closeTicket')->name('close');
    Route::get('download/{ticket}', 'ticketDownload')->name('download');
});

Route::get('app/deposit/confirm/{hash}', 'Gateway\PaymentController@appDepositConfirm')->name('deposit.app.confirm');

Route::controller('SiteController')->group(function () {

    Route::post('/add/device/token', 'getDeviceToken')->name('add.device.token');
    
    Route::get('/contact', 'contact')->name('contact');
    Route::post('/contact', 'contactSubmit');
    Route::get('/change/{lang?}', 'changeLanguage')->name('lang');

    Route::get('cookie-policy', 'cookiePolicy')->name('cookie.policy');

    Route::get('/cookie/accept', 'cookieAccept')->name('cookie.accept');

    Route::get('blogs', 'blogs')->name('blogs');
    Route::get('blog/{slug}/{id}', 'blogDetails')->name('blog.details');

    Route::get('policy/{slug}/{id}', 'policyPages')->name('policy.pages');

    Route::get('plan', 'plan')->name('plan');
    Route::post('planCalculator', 'planCalculator')->name('planCalculator');
 
    Route::post('/subscribe', 'subscribe')->name('subscribe');

    Route::get('placeholder-image/{size}', 'placeholderImage')->name('placeholder.image');
    Route::post('/planCalculator', 'planCalculator')->name('planCalculator');

    Route::get('/{slug}', 'pages')->name('pages');
    Route::get('/', 'index')->name('home'); 
    
});