<?php $__env->startSection('content'); ?>

<style>
/* BODY */
body.tiktok-theme {
    margin: 0;
    padding: 0;
    font-family: 'Arial', sans-serif;
    background: linear-gradient(to bottom, #000000, #111111);
    color: #fff;
}

/* GOLD COLOR */
.gold {
    color: gold !important;
    font-weight: bold;
}

/* FEED */
.feed-container {
    display: flex;
    flex-direction: column;
    gap: 15px;
    padding: 10px;
    padding-bottom: 100px; /* ruang bawah tambahan */
}

/* TOP BAR */
.top {
    height: 60px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: bold;
    font-size: 20px;
    background-color: #111;
    position: sticky;
    top: 0;
    z-index: 10;
    border-bottom: 1px solid #222;
}

/* CARD BASE */
.card {
    background-color: #1a1a1a;
    border-radius: 20px;
    padding: 15px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.5);
    position: relative;
    transform: translateY(30px);
    opacity: 0;
    transition: all 0.6s ease;
}

.card.visible {
    transform: translateY(0);
    opacity: 1;
}

.card:hover {
    transform: scale(1.02);
}

/* CARD HEADERS */
.card h3 {
    margin: 5px 0;
    font-size: 18px;
}

.card p {
    margin: 0;
    font-size: 12px;
    color: #aaa;
}

/* COPY BUTTON */
.copy-btn {
    position: absolute;
    top: 10px;
    right: 10px;
    background: gold;
    color: #000;
    padding: 6px 10px;
    border-radius: 12px;
    font-size: 12px;
    cursor: pointer;
    user-select: none;
    transition: all 0.2s;
}

.copy-btn:hover {
    background: #ffd700;
}

/* POPUP COPIED */
.copied-popup {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    background: gold;
    padding: 8px 16px;
    border-radius: 12px;
    color: #000;
    font-size: 14px;
    opacity: 0;
    pointer-events: none;
    transition: all 0.4s ease;
    z-index: 20;
}

/* TEAM LEVEL CARD */
.team-level {
    display: flex;
    flex-direction: column;
    gap: 10px;
}

.team-level-header {
    display: flex;
    align-items: center;
    gap: 10px;
    font-weight: bold;
}

.team-level-header img {
    width: 35px;
    height: 35px;
}

.team-level-info {
    display: flex;
    justify-content: space-between;
    border-top: 1px solid #333;
    padding-top: 10px;
}

.team-level-info dl {
    margin: 0;
}

.team-level-info dt {
    font-weight: bold;
    color: gold;
}

.team-level-info dd {
    margin: 0;
    color: #ccc;
    font-size: 12px;
}

.team-level a {
    color: gold;
    font-weight: bold;
    text-decoration: none;
    font-size: 14px;
}

.team-level a:hover {
    text-decoration: underline;
}

/* REFERRAL INPUT */
.referral-input {
    background: #111;
    padding: 8px 12px;
    border-radius: 12px;
    color: gold;
    font-weight: bold;
    overflow-x: auto;
    width: 100%;
    box-sizing: border-box;
}
</style>

<div style="display:none;">
<input type="text" value="<?php echo e(route('home')); ?>?invitecode=<?php echo e(auth()->user()->refCode); ?>" id="refInput">
</div>

<div class="copied-popup gold" id="copiedPopup">Copied!</div>

<script>
// COPY FUNCTION
function copyReferral() {
    var input = document.getElementById("refInput");
    input.select();
    input.setSelectionRange(0, 99999);
    navigator.clipboard.writeText(input.value);

    var popup = document.getElementById("copiedPopup");
    popup.style.opacity = 1;
    setTimeout(() => {
        popup.style.opacity = 0;
    }, 1500);
}

// SCROLL ANIMATION
function revealOnScroll() {
    const cards = document.querySelectorAll('.card');
    const windowBottom = window.innerHeight;
    cards.forEach(card => {
        const cardTop = card.getBoundingClientRect().top;
        if(cardTop < windowBottom - 50) {
            card.classList.add('visible');
        }
    });
}

window.addEventListener('scroll', revealOnScroll);
window.addEventListener('load', revealOnScroll);
</script>

<body class="tiktok-theme">
<div class="top">Tim</div>

<div class="feed-container">

    <!-- SUMMARY CARD -->
    <div class="card">
        <h3>Ringkasan Tim</h3>
        <div style="display:flex; justify-content:space-between; margin-top:10px;">
            <div>
                <p>Total Anggota</p>
                <h3 class="gold"><?php echo e(refTotalCount($user->id)); ?></h3>
            </div>
            <div>
                <p>Tim Mengisi Ulang</p>
                <h3 class="gold"><?php echo e(showAmount(refTotalDeposit($user->id))); ?></h3>
            </div>
            <div>
                <p>Penarikan Tim</p>
                <h3 class="gold"><?php echo e(showAmount(refTotalWithdraw($user->id))); ?></h3>
            </div>
            <div>
                <p>Berlaku Hari Ini</p>
                <h3 class="gold"><?php echo e(refTodayCount($user->id)); ?></h3>
            </div>
        </div>
    </div>

    <!-- REFERRAL CODE CARD -->
    <div class="card">
        <h3>Kode Undangan</h3>
        <div class="referral-input gold"><?php echo e(auth()->user()->refCode); ?></div>
        <div class="copy-btn" onclick="copyReferral()">Copy</div>
    </div>

    <!-- REFERRAL LINK CARD -->
    <div class="card">
        <h3>Tautan Undangan</h3>
        <div class="referral-input gold"><?php echo e(route('home')); ?>?invitecode=<?php echo e(auth()->user()->refCode); ?></div>
        <div class="copy-btn" onclick="copyReferral()">Copy</div>
    </div>

    <!-- TEAM LEVEL CARDS -->
    <?php for($i = 1; $i <= 3; $i++): ?>
    <div class="card team-level">
        <div class="team-level-header">
            <img src="<?php echo e(asset('core/img/lv.png')); ?>" alt="">
            <span class="gold"><?php if($i==1): ?>B <?php elseif($i==2): ?>C <?php else: ?> D <?php endif; ?></span>
        </div>
        <div class="team-level-info">
            <dl>
                <dt class="gold"><?php echo e(showAmount(teamDeposit($user->id, $i))); ?></dt>
                <dd>Pendapatan terakumulasi</dd>
            </dl>
            <dl>
                <dt class="gold"><?php echo e(teamSize($user->id, $i)); ?></dt>
                <dd>Jumlah Orang</dd>
            </dl>
        </div>
        <a href="<?php echo e(route('user.referrals.teams', $i)); ?>" class="gold">Rincian</a>
    </div>
    <?php endfor; ?>

</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aureustweb/affiliate.finexa.biz.id/core/resources/views/templates/invester/user/referrals.blade.php ENDPATH**/ ?>