    <!-- header-section start  -->
    <header class="header-section">
        <div class="header-top">
            <div class="container-fluid">
                <div class="header-top-content d-flex flex-wrap align-items-center justify-content-between">
                    <div class="header-top-left">
                        <?php if($general->language_switch): ?>
                            <?php
                                $language = App\Models\Language::all();
                            ?>
                            <select class="langSel">
                                <?php $__currentLoopData = $language; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($item->code); ?>" <?php if(session('lang') == $item->code): ?> selected <?php endif; ?>><?php echo e(__($item->name)); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        <?php endif; ?>
                    </div>
                    <div class="header-top-right">
                        <div class="header-action d-flex flex-wrap align-items-center">
                            <?php if(auth()->guard()->guest()): ?>
                                <a href="<?php echo e(route('user.login')); ?>" class="btn btn-primary btn-small"><?php echo app('translator')->get('Login'); ?></a>
                                <a href="<?php echo e(route('user.register')); ?>" class="btn btn-primary btn-small"><?php echo app('translator')->get('Register'); ?></a>
                            <?php else: ?>
                                <a href="<?php echo e(route('user.logout')); ?>" class="btn btn-primary btn-small w-auto"><?php echo app('translator')->get('Logout'); ?></a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="header-bottom">
            <div class="container-fluid">
                <nav class="navbar navbar-expand-xl align-items-center">

                    <a href="<?php echo e(route('home')); ?>" class="site-logo site-title">
                        <img src="<?php echo e(getImage(getFilePath('logoIcon') . '/logo.png')); ?>" alt="logo">
                    </a>
                    <button class="navbar-toggler ms-auto" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                        <span class="menu-toggle"></span>
                    </button>
                    <div class="collapse navbar-collapse" id="navbarSupportedContent">
                        <ul class="navbar-nav main-menu ms-auto">
                            <li><a href="<?php echo e(route('home')); ?>"><?php echo e(trans('Home')); ?></a></li>
                            <?php
                                $pages = App\Models\Page::where('tempname', $activeTemplate)
                                    ->where('is_default', 0)
                                    ->get();
                            ?>
                            <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><a href="<?php echo e(route('pages', [$data->slug])); ?>"><?php echo e(__($data->name)); ?></a></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <li><a href="<?php echo e(route('plan')); ?>"><?php echo e(trans('Plan')); ?></a></li>
                            <li><a href="<?php echo e(route('blogs')); ?>"><?php echo app('translator')->get('Blog'); ?></a></li>
                            <li><a href="<?php echo e(route('contact')); ?>"><?php echo app('translator')->get('Contact'); ?></a></li>

                            <?php if(auth()->guard()->guest()): ?>
                                <li class="d-sm-none"><a href="<?php echo e(route('user.login')); ?>"><?php echo app('translator')->get('Login'); ?></a></li>
                                <li class="d-sm-none"><a href="<?php echo e(route('user.register')); ?>"><?php echo app('translator')->get('Register'); ?></a></li>
                            <?php endif; ?>

                            <?php if(auth()->guard()->check()): ?>
                                <li><a href="<?php echo e(route('user.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a></li>
                            <?php endif; ?>
                            <?php if($general->language_switch): ?>
                                <li class="menu_has_children d-sm-none">
                                    <select class="langSel">
                                        <?php $__currentLoopData = $language; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($item->code); ?>" <?php if(session('lang') == $item->code): ?> selected <?php endif; ?>><?php echo e(__($item->name)); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </li>
                            <?php endif; ?>
                        </ul>

                    </div><!-- navbar-collapse end -->
                </nav>
            </div>
        </div>
    </header>
<?php /**PATH /home/top1/trustpay.56-0.top/core/resources/views/templates/neo_dark/partials/header.blade.php ENDPATH**/ ?>