<?php $__env->startSection('content'); ?>
<style>
  body {
    background: #000;
    font-family: 'Segoe UI', sans-serif;
    margin: 0;
    padding: 20px;
  }
  .wrapper {
    max-width: 520px;
    margin: auto;
    background: #111;
    border: 2px solid #FFD700;
    border-radius: 10px;
    padding: 28px;
    box-shadow: 0 0 25px rgba(255,215,0,0.2);
  }
  .title {
    font-size: 22px;
    font-weight: 700;
    text-align: center;
    margin-bottom: 15px;
    color: #FFD700;
    border-bottom: 2px dashed #FFD700;
    padding-bottom: 10px;
  } 
  .amount-box {
    background: linear-gradient(135deg, #2e2e2e, #1a1a1a);
    color: #fff;
    text-align: center;
    border-radius: 12px;
    padding: 14px 20px;
    margin: 20px 0;
    border: 2px solid #FFD700;
    box-shadow: 0 0 12px rgba(255,215,0,0.3);
  }
  .amount-box .label { font-size: 15px; opacity: 0.9; }
  .amount-box .amount {
    font-size: 28px;
    font-weight: bold;
    margin-top: 10px;
    letter-spacing: 1px;
    color: #FFD700;
  }
  .countdown { margin-top: 8px; font-size: 13px; color: #facc15; } 
  
  .qr { text-align: center; margin: 25px 0 10px 0; }
  .qr img { max-width: 220px; border-radius: 12px; border: 2px solid #FFD700; box-shadow: 0 0 12px rgba(255,215,0,0.4); }
  .qr-note { font-size: 13px; color: #fff; margin-top: 8px; }
  .confirm-btn {
    width: 100%;
    background: linear-gradient(90deg,#FFD700,#eab308);
    color: #000;
    padding: 14px;
    border: none;
    border-radius: 8px;
    font-weight: 600;
    font-size: 16px;
    cursor: pointer;
    transition: all 0.3s ease;
    margin-top: 10px;
  }
  .confirm-btn:hover { background: linear-gradient(90deg,#facc15,#ca8a04); }

  .accordion {
    margin-top: 30px;
    border-radius: 12px;
    overflow: hidden;
    border: 2px solid #FFD700;
    box-shadow: 0 0 12px rgba(255,215,0,0.2);
  }
  .accordion-item { border-bottom: 1px solid #FFD700; }
  .accordion-header {
    padding: 16px;
    background: #1c1c1c;
    cursor: pointer;
    font-size: 15px;
    font-weight: 500;
    display: flex;
    justify-content: space-between;
    align-items: center;
    color: #FFD700;
  }
  .accordion-content {
    display: none;
    padding: 16px;
    font-size: 14px;
    color: #fff;
    background: #111;
    line-height: 1.5;
  }
  .accordion-header:after {
    content: "⌄";
    font-size: 18px;
    transition: transform 0.3s ease;
  }
  .accordion-header.active:after { transform: rotate(180deg); } 
  .viser-wrapper input[type="file"] {
  position: relative;
  left: 50%;                      /* center */
  transform: translateX(-50%);
  margin-top: 8px;

  width: 100%;
  max-width: 360px;
  border: 2px dashed #FFD700;     /* border emas */
  padding: 14px;
  border-radius: 12px;
  background: #1a1a1a;            /* dark background */
  color: #FFD700;                 /* teks emas */
  font-weight: 500;
  cursor: pointer;
  text-align: center;
  transition: all 0.3s ease;
  box-shadow: 0 0 12px rgba(255,215,0,0.2);
}

.viser-wrapper input[type="file"]:hover {
  border-color: #facc15;          /* gold terang pas hover */
  background: #262626;
  color: #facc15;
  box-shadow: 0 0 18px rgba(250,204,21,0.4);
}

/* Tulisan helper di bawah input */
.viser-wrapper * {
  font-size: 13px;
  color: #FFD700 !important;
  margin-top: 12px;
  text-align: center;
}
</style>

<div class="wrapper">
  <div class="title">Konfirmasi Pembayaran Anda</div>

  <div class="amount-box">
    <div class="label">Total yang harus dibayar</div>
    <div class="amount"><?php echo e($data['method_currency']); ?> <?php echo e(showAmount($data['final_amo'])); ?></div>
    <div id="countdown" class="countdown"></div>
  </div>

  <div class="qr">
    <img src="<?php echo e(asset('assets/images/logoIcon/qris.png')); ?>" alt="QRIS">
    <div class="qr-note">Silakan scan QR menggunakan aplikasi m-Banking / E-Wallet</div>
  </div>

  <form action="<?php echo e(route('user.deposit.manual.update')); ?>" method="POST" enctype="multipart/form-data">
    <?php echo csrf_field(); ?>
    <input type="hidden" name="amount" value="<?php echo e($data['final_amo']); ?>">
    <input type="hidden" name="payment_method" value="<?php echo e($data->gateway->name); ?>">

    <div class="step-content viser-wrapper">
      <?php if (isset($component)) { $__componentOriginale40beaa5cbfa24869bd0b7ba4d9f41184a3f12f0 = $component; } ?>
<?php $component = App\View\Components\ViserForm::resolve(['identifier' => 'id','identifierValue' => ''.e($gateway->form_id).''] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('viser-form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\ViserForm::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'viser-form']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale40beaa5cbfa24869bd0b7ba4d9f41184a3f12f0)): ?>
<?php $component = $__componentOriginale40beaa5cbfa24869bd0b7ba4d9f41184a3f12f0; ?>
<?php unset($__componentOriginale40beaa5cbfa24869bd0b7ba4d9f41184a3f12f0); ?>
<?php endif; ?>
    </div>
    <button type="submit" class="confirm-btn">✅ Saya Sudah Membayar</button>
  </form>

  <div class="accordion">
    <div class="accordion-item">
      <div class="accordion-header">Petunjuk Scan QR via mBanking</div>
      <div class="accordion-content">
        <ol>
          <li>Buka aplikasi mBanking (contoh BCA Mobile, Livin Mandiri, dll).</li>
          <li>Pilih menu QRIS atau Bayar dengan QR.</li>
          <li>Scan QR di atas, pastikan jumlahnya sesuai.</li>
          <li>Masukkan PIN/OTP jika diminta.</li>
          <li>Simpan bukti pembayaran.</li>
        </ol>
      </div>
    </div>
    <div class="accordion-item">
      <div class="accordion-header">Petunjuk Scan QR via E-Wallet</div>
      <div class="accordion-content">
        <ol>
          <li>Buka aplikasi e-Wallet (OVO, DANA, ShopeePay, dll).</li>
          <li>Pilih menu Bayar atau Scan QR.</li>
          <li>Scan QR dan cek jumlah transfer.</li>
          <li>Tekan Bayar dan masukkan PIN.</li>
          <li>Simpan bukti transaksi.</li>
        </ol>
      </div>
    </div>
  </div>
</div>

<script>
  // Countdown tetap
  let expired = <?php echo e($expired ?? \Carbon\Carbon::now()->addMinutes(15)->timestamp); ?>;
  let countdownEl = document.getElementById('countdown');
  let timer = setInterval(function(){
    let now = Math.floor(Date.now() / 1000);
    let diff = expired - now;
    if(diff <= 0){
        countdownEl.innerHTML = "⛔ Waktu habis. Silakan ulangi proses deposit.";
        clearInterval(timer);
    } else {
        let m = Math.floor(diff / 60);
        let s = diff % 60;
        countdownEl.innerHTML = `⏳ Sisa waktu pembayaran: ${m} menit ${s} detik`;
    }
  }, 1000);

  // ===== ACCORDION FIX =====
  document.querySelectorAll(".accordion-header").forEach(header => {
    header.addEventListener("click", function() {
      let content = this.nextElementSibling;

      // Tutup semua dulu
      document.querySelectorAll(".accordion-content").forEach(c => {
        if(c !== content){
          c.style.display = "none";
          c.previousElementSibling.classList.remove("active");
        }
      });

      // Toggle yang diklik
      if(content.style.display === "block"){
        content.style.display = "none";
        this.classList.remove("active");
      } else {
        content.style.display = "block";
        this.classList.add("active");
      }
    });
  });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make($activeTemplate.'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aureustweb/affiliate-center.biz.id/core/resources/views/templates/invester/user/payment/manual.blade.php ENDPATH**/ ?>