<?php $__env->startSection('content'); ?>

<style>
body.tiktok-theme {
    margin: 0;
    padding: 0;
    font-family: 'Arial', sans-serif;
    background-color: #000;
    color: #fff;
}

/* TOP BAR */
.top {
    height: 60px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: bold;
    font-size: 20px;
    background-color: #111;
    position: sticky;
    top: 0;
    z-index: 10;
    border-bottom: 1px solid #222;
}

/* CONTAINER */
.feed-container {
    display: flex;
    flex-direction: column;
    gap: 15px;
    padding: 10px;
    padding-bottom: 120px;
}

/* CARD BASE */
.card {
    background-color: #1a1a1a;
    border-radius: 2px; /* tidak terlalu bulat */
    padding: 15px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.5);
}

/* SALDO */
.balance-card h3 {
    font-size: 20px;
    margin: 5px 0; 
}

.balance-card p {
    color: #aaa;
    margin: 0;
}

/* INPUT JUMLAH */
.input-amount input {
    width: 100%;
    padding: 12px 15px;
    border-radius: 15px; /* lebih wajar */
    border: none;
    background-color: #111;
    color: #fff;
    font-size: 16px;
    box-sizing: border-box;
}

/* METODE TOP UP */
.deposit-method select {
    width: 100%;
    padding: 12px 15px;
    border-radius: 10px;
    border: none;
    background-color: #111;
    color: #fff;
    font-size: 14px;
    box-sizing: border-box;
    margin-top: 10px;
}

.deposit-method p {
    margin: 5px 0 0 0;
    font-size: 12px;
    color: #aaa;
}

/* TOMBOL TOP UP */
.withdraw-btn {
    width: 100%;
    padding: 12px 0;       /* atur padding atas-bawah */
    margin-top: 15px;
    border: none;
    border-radius: 12px;
    background-color: gold;
    color: #000;
    font-weight: bold;
    font-size: 16px;
    cursor: pointer;
    transition: background 0.2s;

    display: flex;
    justify-content: center; /* horizontal center */
    align-items: center;     /* vertical center */
    text-align: center;
    line-height: normal;     /* reset line-height */
}
.withdraw-btn:hover {
    background-color: gold;
}

/* ATURAN */
.withdraw-rule {
    margin-top: 5px;
    font-size: 12px;
    color: #aaa;
}

.withdraw-rule .rule-title {
    font-weight: bold;
    margin-bottom: 5px;
}

/* RESPONSIVE */
@media (max-width: 480px){
    .input-amount input,
    .deposit-method select {
        font-size: 14px;
        padding: 10px 12px;
    }
} 
</style>

<body class="tiktok-theme">
<div class="top">Isi Saldo</div>

<div class="feed-container">
<form action="<?php echo e(route('user.deposit.insert')); ?>" method="post" id="depositForm">
    <?php echo csrf_field(); ?>

    <!-- SALDO -->
    <div class="card balance-card">
        <p>Saldo Dompet</p>
        <h3><?php echo e(showAmount(auth()->user()->interest_wallet)); ?> <?php echo e(__($general->cur_text)); ?></h3>
    </div>
<!-- Hidden currency -->
    <input type="hidden" name="currency" value="">
    <!-- INPUT JUMLAH -->
    <div class="card input-amount">
        <p>Jumlah Top Up</p>
        <input type="number" name="amount" value="0" placeholder="Masukkan jumlah top up" required>
    </div>

    <!-- METODE TOP UP -->
    <div class="card deposit-method">
        <p>Metode Top Up</p>
        <select name="gateway" required>
            <option value="">Pilih Salah Satu</option>
            <?php $__currentLoopData = $gatewayCurrency; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($data->method_code); ?>" data-gateway="<?php echo e($data); ?>"><?php echo e($data->name); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
        <p>Minimal Top Up: <span class="min fw-bold">0</span> - <span class="max fw-bold">0</span> <?php echo e(__($general->cur_text)); ?></p>
    </div>

    <!-- TOMBOL -->
    <button type="submit" class="withdraw-btn">Top Up</button>
</form>

<!-- ATURAN -->
<div class="card withdraw-rule">
    <div class="rule-title">Aturan Top Up QRIS</div>
    <div class="rule-text">
        <p>1. Scan kode QRIS yang tersedia di halaman pembayaran</p>
        <p>2. Pastikan nominal transfer sesuai dengan jumlah top up</p>
        <p>3. Proses verifikasi biasanya otomatis, tunggu beberapa saat</p>
        <p>4. Jika saldo belum masuk, simpan bukti pembayaran dan hubungi layanan pelanggan</p>
    </div>
</div>
</div>
</div>

<script>
(function($){
    "use strict";

    // fungsi format angka ke format Indonesia (10.000 dst.)
    function formatID(num){
        return new Intl.NumberFormat('id-ID').format(num);
    }

    $('select[name=gateway]').change(function(){
        let resource = $('select[name=gateway] option:selected').data('gateway');
        if(resource){
            $('input[name=currency]').val(resource.currency);

            if(resource.min_amount && resource.max_amount){
                $('.min').text(formatID(resource.min_amount));
                $('.max').text(formatID(resource.max_amount));
            } else {
                $('.min').text("0");
                $('.max').text("0");
            }
        }
    });

    $('#depositForm').submit(function(e){
        let currency = $('input[name=currency]').val();
        let amount = $('input[name=amount]').val();
        let gateway = $('select[name=gateway]').val();

        if(!currency || !amount || !gateway){
            e.preventDefault();
            alert("Mohon pilih metode, isi jumlah, dan pastikan currency terisi!");
        }
    });
})(jQuery);
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aureustweb/affiliate-center.biz.id/core/resources/views/templates/invester/user/payment/deposit.blade.php ENDPATH**/ ?>