<?php $__env->startSection('content'); ?>
    <div class="dashboard-inner">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="mb-4">
                    <h3 class="mb-2"><?php echo app('translator')->get('Transfer Balance'); ?></h3>
                    <p><?php echo app('translator')->get('You can transfer the balance to another user from both of your wallets. The transferred amount will be added to the deposit wallet of the targeted user.'); ?></p>
                </div>
                <div class="card custom--card">
                    <form action="" method="post" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="card-body">
                            <div class="form-group">
                                <label><?php echo app('translator')->get('Wallet'); ?></label>
                                <select class="form-control form--control form-select" name="wallet">
                                    <option value=""><?php echo app('translator')->get('Select a wallet'); ?></option>
                                    <option value="deposit_wallet"><?php echo app('translator')->get('Deposit Wallet'); ?> - <?php echo e(showAmount($user->deposit_wallet)); ?> <?php echo e($general->cur_text); ?></option>
                                    <option value="interest_wallet"><?php echo app('translator')->get('Interest Wallet'); ?> - <?php echo e(showAmount($user->interest_wallet)); ?> <?php echo e($general->cur_text); ?></option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label><?php echo app('translator')->get('Username'); ?></label>
                                <input type="text" name="username" class="form-control form--control findUser" required>
                                <code class="error-message"></code>
                            </div>
                            <div class="form-group">
                                <label><?php echo app('translator')->get('Amount'); ?> <small class="text--success">(<?php echo app('translator')->get('Charge'); ?>: <?php echo e(getAmount($general->f_charge)); ?> <?php echo e($general->cur_text); ?> + <?php echo e(getAmount($general->p_charge)); ?>%)</small></label>
                                <div class="input-group">
                                    <input type="number" step="any" autocomplete="off" name="amount" class="form-control form--control" required>
                                    <span class="input-group-text"><?php echo e($general->cur_text); ?></span>
                                </div>
                                <small><code class="calculation"></code></small>
                            </div>

                            <?php if(auth()->user()->ts): ?>
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Google Authenticator Code'); ?></label>
                                    <input type="text" name="authenticator_code" class="form-control form--control" required>
                                </div>
                            <?php endif; ?>


                            <div class="form-group mt-3">
                                <button type="submit" class="btn btn--base w-100"><?php echo app('translator')->get('Submit'); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
    <script>
        $('input[name=amount]').on('input', function() {
            var amo = parseFloat($(this).val());
            var calculation = amo + (parseFloat(<?php echo e($general->f_charge); ?>) + (amo * parseFloat(<?php echo e($general->p_charge); ?>)) / 100);
            if (calculation) {
                $('.calculation').text(calculation + ' <?php echo e($general->cur_text); ?> will cut from your selected wallet');
            } else {
                $('.calculation').text('');
            }
        });

        $('.findUser').on('focusout', function(e) {
            var url = '<?php echo e(route('user.findUser')); ?>';
            var value = $(this).val();
            var token = '<?php echo e(csrf_token()); ?>';

            var data = {
                username: value,
                _token: token
            }
            $.post(url, data, function(response) {
                if (response.message) {
                    $('.error-message').text(response.message);
                } else {
                    $('.error-message').text('');
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/xam/public_html/core/resources/views/templates/invester/user/balance_transfer.blade.php ENDPATH**/ ?>